
#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 | forrest@unc.edu or http://forrest.psych.unc.edu
 |
 | This file contains I/O functions for preference files
 | PREFLOAD.LSP INITIAL.LSP VERSION.LSP and VERBOSE.LSP
 | Methods for PREFS.LSP are in systmob2.lsp
 | 
 | These functions are used to initialize and remember parameter values.
 | The distribution defaults are set by the (write-prefload-file) function
 | which is also used to remember values from one session to the next.
 | The other functions serve the same purpose for more specialized situations.
 |
 | (setf *clock* nil)
 | (setf *show-clock-logo* nil)
 | (setf *clock-hides-desktop* nil)
 | (setf *full-screen-clock* nil)
 | (setf *dynamic-clock-logo* nil)
 | (setf *show-elapsed-time* t)
 |____________________________________________________________________
 |#

;fwy added file-verbose statement 09-22-02
(defun backup-prefs-files ()
"Args: none
Creates backup copies of all preference files."
     (mapcar #'(lambda (file)
                 (let ((in (strcat *prefs-path* file ".lsp"))
                       (out (strcat *prefs-path* file "-bak.lsp")))
                   (copy-file in out)
                   (when *file-verbose* (format t "; copyfile ~a~%" in))
                   ))
             *pref-filenames*))

(defun restore-prefs-files ()
"Args: none
Restores preference files from backup copies."
     (mapcar #'(lambda (file)
                 (let ((out (strcat *prefs-path* file ".lsp"))
                       (in (strcat *prefs-path* file "-bak.lsp")))
                   (copy-file in out)))
             *pref-filenames*))


#|
 | PREFLOAD FILE
 |
 | read-prefload-file, write-prefload-file
 | open-prefload-file, initialize-prefload-file
 |
 |#


(defun initialize-prefload-file ()
  (setf *initial-install* t)
  (setf *no-restart* nil)
  (setf *config-vistaxls* t)
  (write-initial-file t)
  (write-prefload-file t))

(defun read-prefload-file ()
(when *v* (format t "; Loading Prefload"))
(if *prefs-dir-name*
      (failsafe-load *prefs-dir-name* "prefload.lsp" 
            :direction :input :if-does-not-exist nil)
      nil))
    
(defun open-prefload-file ()
(when *v* (format t "; Opening Prefload"))
(if *prefs-dir-name*
      (open (strcat *prefs-dir-name* "prefload.lsp") 
            :direction :input :if-does-not-exist nil)
      nil))


(defun write-prefload-file (&optional make-distribution pref-path)
"Args: &optional make-distribution pref-path"
  (setf *make-distribution* make-distribution)
  (update-desktop-sizeloc-info)
  (write-version-file pref-path)
  (let* ((oldbreak *breakenable*)
         (preffile (if pref-path 
                       (strcat pref-path "prefload.lsp")
                       (strcat *prefs-dir-name* "prefload.lsp")))
         (plfile (probe-file preffile)))
    (when (or *genesys* plfile) (setf plfile (open preffile :direction :output)))
    (when make-distribution (write-verbose-file t pref-path))
    (setf *breakenable* nil)
    
    (cond 
      ((not plfile)
       (when *v* (format t "; Cannot write preference files.~%"))
       (message-dialog "Cannot write preference files.~%"))
      (t
       (write-initial-file make-distribution preffile)       
       (when make-distribution (setf *run-number* -10))
       (prefs-fixed plfile)
       (cond
         (make-distribution 
          (prefs-distribution-1 plfile)
          (prefs-distribution-2 plfile))
         (t
          (prefs-nondistribution-1 plfile)
          (prefs-nondistribution-2 plfile)))
       (format plfile "~%(setf *workmap-background* '~d)" *workmap-background*)
       (format plfile "~%(setf *toolbar-background* '~d)" *toolbar-background*)  
       (format plfile "~%(setf *data-icon-color*    '~d)" *data-icon-color*)
       (format plfile "~%(setf *model-icon-color*   '~d)" *model-icon-color*)
       (format plfile "~%(setf *data-icon-cap-color*  '~d)" *data-icon-cap-color*)
       (format plfile "~%(setf *model-icon-cap-color* '~d)" *model-icon-cap-color*)
       (format plfile "~%(setf *freq-icon-color*      '~d)" *freq-icon-color*)
       (format plfile "~%(setf *freqclass-icon-color* '~d)" *freqclass-icon-color*)
       (format plfile "~%(setf *mv-icon-color*      '~d)" *mv-icon-color*)
       (format plfile "~%(setf *class-icon-color*   '~d)" *class-icon-color*)
       (format plfile "~%(setf *cat-icon-color*     '~d)" *cat-icon-color*)
       (format plfile "~%(setf *missing-icon-color* '~d)" *missing-icon-color*)
       (format plfile "~%(setf *dissim-icon-color*  '~d)" *dissim-icon-color*)
       (format plfile "~%(setf *tool-icon-color*    '~d)" *tool-icon-color*)
       (format plfile "~%(setf *guide-icon-color*   '~d)"   *guide-icon-color*)
       (format plfile "~%(setf *button-on-color*    '~d)"    *button-on-color*)
       (format plfile "~%(setf *button-off-color*   '~d)"   *button-off-color*)
       (format plfile "~%(setf *debug-mode*         '~d)" *debug-mode* nil)
       (setq *breakenable* oldbreak)
       (close plfile)
       (when *file-verbose* 
          (format t "~a~%" (strcat "; saving  " *prefs-path* "prefload.lsp")))
       ))))

;this screwy structure is used because
;the compile chokes on bigger functions

(defun prefs-fixed (plfile)
  (prefs-fixed1 plfile)
  (prefs-fixed2 plfile))

(defun prefs-fixed1 (plfile)  
  (print `(setf *print-help-mode* nil) plfile)
  (print `(setf *auto-activate* ,*auto-activate* ) plfile)
  (print `(setf *auto-type-shift* ,*auto-type-shift* ) plfile)  
  (print `(setf *viva* ,*viva*) plfile)
  (print `(setf *show-datasheet-after-loading-data* 
                ,*show-datasheet-after-loading-data* ) plfile)
  (print `(setf *full-screen-desktop* ,*full-screen-desktop*) plfile)
  (print `(setf *log-number* ,*log-number*) plfile)
  (print `(setf *build-number* ,*build-number*) plfile)
  (print `(setf *local-vista-id-number* nil) plfile)
  (print `(setf *vista-id-number* nil) plfile)
  (print `(setf *registration-number*  ,*registration-number*) plfile)
  (print `(setf *install-id* ,*install-id*) plfile)
  (print `(setf *vista-id-number* ,*vista-id-number*) plfile)
  (print `(setf *vista-id* ,*vista-id*) plfile)
  (print `(setf *compile-id* ,*compile-id*) plfile)
  (print `(setf *distribution-id* ,*distribution-id*)  plfile)
  (print `(setf *distributor-id* ,*distributor-id*)  plfile)
  (print `(setf *builder-id* ,*builder-id*)  plfile)
  (print `(setf *compile-date* ,*compile-date*)  plfile)
  (print `(setf *build-date* ,*build-date*)  plfile)
  (print `(setf *distribution-date* ,*build-date*)  plfile)
  (print `(setf *install-date* ,*install-date*)  plfile)
  (print `(setf *load-number* ,*load-number*) plfile)
  (print `(setf *run-number* ,*run-number* ) plfile)
  (print `(setf *local-install-number* ,*local-install-number* ) plfile)
  (print `(setf *release-date* , *release-date*) plfile)
  (print `(setf *release-number* , *release-number*) plfile)
  (print `(setf *release-language* , *release-language*) plfile)
  (print `(setf *install-date* ,*install-date*) plfile)
  (print `(setf *pro-version* ,*pro-version*) plfile)
  (print `(setf *after-making-vista-choice* ,*after-making-vista-choice*) plfile)
  (print `(setf *make-vista-configuration-choice* 
                ,*make-vista-configuration-choice* ) plfile)
  (print `(setf *install-developer* ,*install-developer*) plfile)
  )
  

(defun prefs-fixed2 (plfile)  
  (print `(setf *vista-start-case* ,*vista-start-case*) plfile)
  (print `(setf *make-distribution* ,*make-distribution*) plfile)
  (print `(setf *author* ,*author*) plfile)
  (print `(setf ini-exists? ,ini-exists?) plfile)
  (print `(setf *compiled-file-listing?* ,*compiled-file-listing?* ) plfile)
  (print `(setf *Distribution-WorkSpace?* ,*Distribution-WorkSpace?*) plfile)
  (print `(setf *color-mode* ,*color-mode*) plfile)
  (print `(setf *devel-mode* ,*devel-mode*) plfile)	
  (print `(setf *max-load-speed* ,*max-load-speed*) plfile)
  (print `(setf *no-restart* ,*no-restart*) plfile)
  (print `(setf *macos8* ,*macos8*) plfile)
  (print `(setf *user-type*  ,*user-type* ) plfile)
  (print `(setf *installer-type*  ,*installer-type* ) plfile)
  (print `(setf *one-click-workmap* t) plfile)
  (print `(setf *free-spreadplots* ,*free-spreadplots*) plfile)
  (print `(setf *free-about-window* ,*free-about-window*) plfile)
  (print `(setf *fast-start* ,*fast-start*) plfile)
  (print `(setf *rebuild-after-compile-needed* ,*rebuild-after-compile-needed*) plfile)
  (print `(setf *COMPILE-AFTER-LOADING-NEEDED* ,*COMPILE-AFTER-LOADING-NEEDED*) plfile)
  (format plfile "~%(setf *mainwindow-loc-size* (list ~d ~d ~d ~d))"
          (first *mainwindow-loc-size*) (second *mainwindow-loc-size*) 
          (third *mainwindow-loc-size*) (fourth *mainwindow-loc-size*))
  (format plfile "~%(setf *listener-loc-size* (list ~d ~d ~d ~d))"
          (first *listener-loc-size*) (second *listener-loc-size* ) 
          (third *listener-loc-size* ) (fourth *listener-loc-size* ))
  (print `(setf *installation-type* ,*installation-type*) plfile)
  (print `(setf *computing-environment* ,*computing-environment*) plfile)
  (print `(setf *force-user-mode* ,*force-user-mode*) plfile)
  )

(defun prefs-distribution (plfile)
  (prefs-distribution-1 plfile)
  (prefs-distribution-3 plfile)
  )

(defun prefs-distribution-1 (plfile)
  (print `(setf *load-files-with-running-vista* nil) plfile)
  (print `(setf *drag-icon-image* nil) plfile)
  (print `(setf *dash-edit-button-bar* nil) plfile)
  (print `(setf *auto-activate* nil) plfile)
  (print `(setf *auto-type-shift* t) plfile)
  (print `(setf *history* nil) plfile)
  (print `(setf *viva* t) plfile)
  (print `(setf *show-datasheet-after-loading-data* t) plfile)
  (print `(setf *full-screen-desktop* nil) plfile)
  (print `(setf *desktop-layout-state* 3) plfile)
  (print `(setf *seamless-desktop* nil) plfile)
  (print `(setf *thin-borders* nil) plfile)
  (print `(setf *show-flying-logo* t) plfile)
  (print `(setf *show-clock-logo* t) plfile)
  (print `(setf *clock-hides-desktop* nil) plfile)
  (print `(setf *full-screen-clock* nil) plfile)
  (print `(setf *dynamic-clock-logo* t) plfile)
  (print `(setf *show-elapsed-time* nil) plfile)
  (print `(setf *shown-excel-vista-connection-warning?* nil) plfile)
  (print `(setf *debug-mode* nil) plfile)
  (print `(setf *devel-mode* nil) plfile)
  (print `(setf *devel-version* nil) plfile)
  (print `(setf *ini-file* nil) plfile)
  (print `(setf *ini-at-home* t) plfile)
  (print `(setf *change-profiles* t) plfile)
  (print `(setf *update-pref-files* t) plfile)
  (print `(setf *change-workmap* t) plfile)
  (print `(setf *configure* t) plfile)
  (print `(setf *show-devel-mode* t) plfile)
  (print `(setf *default-num-listener-lines* 4) plfile)
  (print `(setf *num-listener-lines* *default-num-listener-lines* ) plfile)
  (print `(setf *change-fonts* t) plfile)
  (print `(setf *change-directories* t) plfile)
  (print `(setf *change-excess* t) plfile)
  (print `(setf *local-excel?* nil) plfile)
  (print `(setf *max-screen-size* '(600 480)) plfile)
  )

(defun prefs-distribution-3 (plfile)
  (print `(setf *no-local-excel?* nil) plfile)
  (print `(setf *show-install-excel-menu-item* t) plfile)
  (print `(setf *enable-screen-saver-feature* t) plfile)
  (print `(setf *screen-saver-full-screen* nil) plfile)
  (print `(setf *hide-vista* nil) plfile)
  (print `(setf *hide-logo* nil) plfile)
  (print `(setf *new-interface-mode* nil) plfile)
  (print `(setf *ni* nil) plfile)
  (print `(setf *one-window-spreadplots* nil) plfile)
  (print `(setf *one-window-desktop* nil) plfile)
  (print `(setf *xlispstat-only* nil) plfile)
  (print `(setf *config-vistaxls* t) plfile)
  )
  
(defun prefs-distribution-2 (plfile)
  (print `(setf *maximized-listener?* nil) plfile)
  (print `(setf *layout-choice* 2) plfile)
  (print `(setf *registered?* nil) plfile)
  (print `(setf *previous-max-screen-size* (list 0 0)) plfile)
  (print `(setf *max-screen-size* (list -1 -1)) plfile)
  (print `(setf *full-screen* t) plfile)
  (print `(setf *frames-per-second* nil) plfile)
  (print `(setf *screen-size* (list 0 0)) plfile)
  (print `(setf *now-screen-size* (list 0 0)) plfile)
  (print `(setf *desktop-loc-size* (list 0 0 0 0)) plfile)
  (print `(setf *about-spot* nil) plfile)
  (print `(setf *seamless-spreadplots* t) plfile)
  (print `(setf *maximize-spreadplots* nil) plfile)
  (print `(setf *nmobs* ,*initial-nmobs*) plfile)
  (print `(setf *nanalys* ,(+ *nplugins* *nmobs*)) plfile)
  (print `(setf *nitems* ,*nanalys*) plfile)
  (print `(setf *nbutts* ,*nmobs*) plfile)
  (print `(setf *num-toolbar-buts-shown-at-startup* ,*nbutts*) plfile)
  (print `(setf *button-names* ',*initial-button-names*) plfile)
  (print `(setf *analysis-menu-items*  ',*initial-analysis-menu-items*) plfile)
  (print `(setf *browser* nil) plfile)
  (print `(setf *browser.exe* nil) plfile)
  (print `(setf *excel.exe* nil) plfile)
  (print `(setf *text-editor.exe* ,nil) plfile)
  (print `(setf *printer.exe* nil) plfile)
  (print `(setf *show-web-docs* t) plfile)
  (print `(setf *realtime-datasheet-update* t) plfile)
  (print `(setf *default-workmap-proportion* .6) plfile)
  )


(defun prefs-nondistribution-1 (plfile)
  (print `(setf *load-files-with-running-vista* ,*load-files-with-running-vista*) plfile)
  (print `(setf *drag-icon-image* ,*drag-icon-image* ) plfile)
  (print `(setf *dash-edit-button-bar* ,*dash-edit-button-bar*) plfile)
  (print `(setf *history* ,*history*) plfile)
  (print `(setf *desktop-layout-state* ,*desktop-layout-state*) plfile)
  (print `(setf *shown-excel-vista-connection-warning?*
                ,*shown-excel-vista-connection-warning?* ) plfile)
  (print `(setf *plotcell-pane-type* ,*plotcell-pane-type*) plfile)
  (print `(setf *debug-mode* ,*debug-mode* ) plfile)
  (print `(setf *devel-version* ,*devel-version*) plfile)
  (print `(setf *ini-file* ,*ini-file*) plfile)
  (print `(setf *ini-at-home* ,*ini-at-home*) plfile)
  (print `(setf *change-profiles* ,*change-profiles* ) plfile)
  (print `(setf *update-pref-files* ,*update-pref-files* ) plfile)
  (print `(setf *change-workmap* ,*change-workmap* ) plfile)
  (print `(setf *configure* ,*configure*  ) plfile)
  (print `(setf *show-devel-menu* ,*show-devel-menu* ) plfile)
  (print `(setf *num-listener-lines* ,(max 4 *num-listener-lines*)) plfile)
  (print `(setf *default-num-listener-lines* 4) plfile)
  (print `(setf *change-fonts* ,*change-fonts*) plfile)
  (print `(setf *change-directories* ,*change-directories*) plfile)
  (print `(setf *change-excess* ,*change-excess*) plfile)
  (print `(setf *local-excel?* *local-excel?*) plfile)
  (print `(setf *no-local-excel?* *no-local-excel?*) plfile)
  (print `(setf *show-configure-no-local-excel-menu-item*
                ,*show-configure-no-local-excel-menu-item* ) plfile)
  (print `(setf *show-configure-local-excel-menu-item*
                ,*show-configure-local-excel-menu-item* ) plfile)
  (print `(setf *enable-screen-saver-feature* 
                ,*enable-screen-saver-feature* ) plfile)
  (print `(setf *screen-saver-full-screen* 
                ,*screen-saver-full-screen* ) plfile)
  (print `(setf *hide-vista* ,*hide-vista*) plfile)
  (print `(setf *hide-logo* ,*hide-logo*) plfile)
  (print `(setf *new-interface-mode* ,*new-interface-mode*) plfile)
  (print `(setf *ni* ,*ni*) plfile)
  (print `(setf *one-window-spreadplots* ,*one-window-spreadplots*) plfile)
  (print `(setf *default-workmap-proportion* 
                ,*default-workmap-proportion*) plfile)
  (print `(setf *one-window-desktop* ,*one-window-desktop*) plfile)
  (print `(setf *xlispstat-only* ,*xlispstat-only*) plfile)
  (print `(setf *config-vistaxls* nil) plfile)
  (print `(setf *show-web-docs* ,*show-web-docs*) plfile)
  (print `(setf *realtime-datasheet-update* ,*realtime-datasheet-update*) plfile)
  (print `(setf *layout-choice* ,*layout-choice*) plfile)
  (print `(setf *registered?* ,*registered?* ) plfile)
  (print `(setf *clock-hides-desktop* ,*clock-hides-desktop* ) plfile)
  (print `(setf *full-screen-clock* ,*full-screen-clock* ) plfile)
  (print `(setf *dynamic-clock-logo* ,*dynamic-clock-logo* ) plfile)
  (print `(setf *show-elapsed-time* ,*show-elapsed-time* ) plfile)
  (print `(setf *max-screen-size* ',*max-screen-size*) plfile)
  )


(defun prefs-nondistribution-2 (plfile)
  (print `(setf *maximized-listener?* ,*maximized-listener?*) plfile)
  (format plfile "~%(setf *previous-max-screen-size* (list ~d ~d ))" 
          (first *max-screen-size*) (second *max-screen-size*))
  (print `(setf *full-screen* ,*full-screen*) plfile)
  (print `(setf *frames-per-second* ,*frames-per-second*) plfile)
  (print `(setf *show-flying-logo* ,*show-flying-logo*) plfile)
  (format plfile "~%(setf *now-screen-size* (list ~d ~d))"
          (first *now-screen-size*) (second *now-screen-size*))
  (format plfile "~%(setf *screen-size* (list ~d ~d ))" 
          (first *screen-size*) (second *screen-size*))
  (format plfile "~%(setf screen-size (list ~d ~d ))" 
          (first *now-screen-size*) (second *now-screen-size*))
  (format plfile "~%(setf *desktop-loc-size* (list ~d ~d ~d ~d))"
          (first *desktop-loc-size*) (second *desktop-loc-size*)
          (third  *desktop-loc-size*) (fourth *desktop-loc-size*))
  (print `(setf *about-spot* ,*about-spot*) plfile)
  (print `(setf *seamless-spreadplots* ,*seamless-spreadplots* ) plfile)
  (print `(setf *seamless-desktop* ,*seamless-desktop* ) plfile)
  (print `(setf *thin-borders* ,*thin-borders*) plfile)
  (print `(setf *maximize-spreadplots* ,*maximize-spreadplots* ) plfile)
  (print `(setf *nmobs* ,*nmobs*) plfile)
  (print `(setf *nanalys* (+ *nplugins* *nmobs*)) plfile)
  (print `(setf *nitems* ,*nitems*) plfile)
  (print `(setf *nbutts* ,*nbutts*) plfile)
  (print `(setf *num-toolbar-buts-shown-at-startup* 
                ,*num-toolbar-buts-shown-at-startup*) plfile)
  (print `(setf *button-names* ',*button-names*) plfile)
  (print `(setf *analysis-menu-items* ',*analysis-menu-items*) plfile)
  (print `(setf *browser*         ,*browser*) plfile)
  (print `(setf *browser.exe*     ,*browser.exe*) plfile)
  (print `(setf *excel.exe*       ,*excel.exe*) plfile)
  (print `(setf *text-editor.exe* ,*text-editor.exe*) plfile)
  (print `(setf *printer.exe*     ,*printer.exe*) plfile)
  (print `(setf *show-clock-logo* ,*show-clock-logo*) plfile)
  (print `(setf *clock-hides-desktop* ,*clock-hides-desktop* ) plfile)
  (print `(setf *full-screen-clock* ,*full-screen-clock* ) plfile)
  (print `(setf *dynamic-clock-logo* ,*dynamic-clock-logo* ) plfile)
  (print `(setf *show-elapsed-time* ,*show-elapsed-time* ) plfile)
  )



#|
 | INITIAL FILE
 |
 | read-initial-file, write-initial-file, load-initial-file
 |
 |#


(defun load-initial-file () (read-initial-file))

(defun read-initial-file ()
  (when *v* (format t "~%; Loading Initial File~%"))
  (cond 
    (*prefs-dir-name*
     (failsafe-load *prefs-dir-name* "initial.lsp" 
           :direction :input :if-does-not-exist nil)
     (when *v* (format t "; *initial-install* = ~a" *initial-install*))
     *prefs-dir-name*)
    (t
     nil)))

(defun write-initial-file (&optional nilt pref-path)
  (let* ((oldbreak *breakenable*)
         (text "GeneSys: initial.lsp")
         (filename (if pref-path
                       (strcat pref-path "initial.lsp")
                       (strcat *prefs-dir-name* "initial.lsp"))))
    (when (or *genesys* (probe-file filename)) 
          (with-open-file 
           (ifile filename
                  :direction :output
                  :if-exists :supersede)
           (setf *breakenable* nil)
           (when *genesys*
                 (format t text)
                 (message-dialog text))
           (cond 
             ((not ifile)
              (when *v* (format t "; Cannot open initial file. Looking for GeneSys.~%"))
              )
             (t
              (when *file-verbose* 
                    (format t "~a~%" (strcat "; saving  " filename)))
              (print `(setf *initial-install* ,nilt) ifile)
              ))
           (setq *breakenable* oldbreak)
           (close ifile)
           ifile))))


#|
 | VERSION FILE
 |
 | read-version-file, write-version-file
 |
 |#


(defun read-version-file ()
(when (and (boundp '*v*) *v*) (format t "; Loading VersionFile"))
(if (and (boundp '*prefs-dir-name*) *prefs-dir-name*)
      (failsafe-load *prefs-dir-name* "version.lsp"
            :direction :input :if-does-not-exist nil)
      (failsafe-load (strcat *default-path* "\\prefs\\") "version.lsp"
            :direction :input :if-does-not-exist nil)))

(defun write-version-file (&optional pref-path)
    (let* ((oldbreak *breakenable*)
           (text "~%GeneSys: version.lsp~%")
           (filename (if pref-path 
                         (strcat pref-path "version.lsp")
                         (strcat *prefs-dir-name* "version.lsp"))))
      (when (or *genesys* (probe-file filename))
            (with-open-file (verfile filename 
                                     :direction :output
                                     :if-exists :supersede)
                            (setf *breakenable* nil)
             (when *genesys* (format t text) (message-dialog text))
             (cond 
               ((not verfile)
                (when *v* (format t "~%; Cannot find writeable version file."))
                (message-dialog "Cannot find writeable version file.")
                )
               ((and *LOG-NUMBER*  *BUILD-NUMBER* *LOAD-NUMBER* *RUN-NUMBER*  
                     *RELEASE-DATE* *RELEASE-NUMBER* *RELEASE-LANGUAGE*)
                (print `(setf *log-number* ,*log-number*) verfile)
                (print `(setf *build-number* ,*build-number*) verfile)
                (print `(setf *load-number* ,*load-number*) verfile)
                (print `(setf *run-number* ,*run-number* ) verfile)
                (print `(setf *release-date* , *release-date*) verfile)
                (print `(setf *release-number* , *release-number*) verfile)
                (print `(setf *release-language* , *release-language*) verfile)
                (print `(setf *pro-version* ,*pro-version*) verfile)
                (print `(setf *xlisponly* ,*xlisponly*) verfile)
                (print `(setf *switching-to-xlisponly* ,*switching-to-xlisponly*) verfile)
                (print `(setf *show-make-steps?* ,*show-make-steps?*) verfile)
                (setq *breakenable* oldbreak)
                (close verfile)
                (when *file-verbose* 
                      (format t "~a~%" (strcat "; saving  " filename)))
                )
               (t
                (when *v* (format t 
                  "~%; Version Information Corrupted. Retrieving Saved Information."))
                (fatal-message 
                  "Version Information Corrupted.    Retrieving Saved Information.")
                (load filename)))
             verfile))))

  

#|
 | VERBOSE FILE
 |
 | write-verbose-file - there is no read-verbose-file function
 |
 |#


(defun write-verbose-file (&optional *make-distribution* pref-path)
  (let* ((oldbreak *breakenable*)
         (verbfile (if pref-path 
                       (strcat pref-path "verbose.lsp")
                       (strcat *prefs-dir-name* "verbose.lsp"))))
    (when (or *genesys* (probe-file verbfile)) 
          (with-open-file (vfile verbfile
                                 :direction :output
                                 :if-exists :supersede)
                          (setf *breakenable* nil)
                          (print `(setf *make-verbose-mode* ,*verbose*) vfile)
                          (print `(setf *container-verbose* ,*container-verbose*) vfile)
                          (print `(setf *debug-mode* ,*debug-mode*) vfile)
                          (print `(setf *breakenable* ,oldbreak) vfile)
                          (when *file-verbose* (format t "~a~%" 
                                  (strcat "; saving  " verbfile )))
                          (setq *breakenable* oldbreak)
                          vfile))))

     